' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Partial Class BlogEntries
  Inherits System.Web.UI.UserControl

  Private startDate As DateTime = DateTime.MinValue
  Private endDate As DateTime = DateTime.MinValue
  Private currentPage As Integer = -1
  Dim categoryId As Integer = -1

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Not Page.IsPostBack Then
      LoadData()
    End If
    If Context.User.IsInRole("Administrator") Then
      btnCreateNewBlogEntry.Visible = True
    End If
  End Sub

  Private Sub LoadData()
    Dim myDataSet As DataSet = Nothing

    If Request.QueryString.Get("startDate") IsNot Nothing Then
      startDate = Convert.ToDateTime(Request.QueryString.Get("startDate"))
      If Request.QueryString.Get("endDate") IsNot Nothing Then
        endDate = Convert.ToDateTime(Request.QueryString.Get("endDate"))
      Else
        endDate = startDate
      End If
      myDataSet = BlogManager.GetBlogEntries(startDate, endDate)
      If endDate = startDate Then
        lblResults.Text = "Poniej wywietlono wpisy w blogu opublikowane dnia " & startDate.ToShortDateString() & "."
      Else
        lblResults.Text = "Poniej wywietlono wpisy w blogu opublikowane pomidzy " & startDate.ToShortDateString() & " a " & endDate.ToShortDateString() & "."
      End If
    Else
      If Request.QueryString.Get("categoryId") IsNot Nothing Then
        myDataSet = BlogManager.GetBlogEntries(Convert.ToInt32(Request.QueryString.Get("categoryId")))
        If myDataSet IsNot Nothing AndAlso myDataSet.Tables.Count > 0 AndAlso myDataSet.Tables(0).Rows.Count > 0 Then
          lblResults.Text = "Poniej wywietlono wpisy blogu o kategorii  " & myDataSet.Tables(0).Rows(0)("Description").ToString() & "."
        End If
      Else
        myDataSet = BlogManager.GetBlogEntries()
        If myDataSet IsNot Nothing AndAlso myDataSet.Tables.Count > 0 AndAlso myDataSet.Tables(0).Rows.Count > 0 Then
          lblResults.Text = "Poniej wywietlono ostatnie " & myDataSet.Tables(0).Rows.Count & " wpis(y) blogu."
        End If
      End If
    End If

    If myDataSet IsNot Nothing AndAlso myDataSet.Tables.Count > 0 AndAlso myDataSet.Tables(0).Rows.Count > 0 Then
      dlBlogEntries.DataSource = myDataSet
      dlBlogEntries.DataBind()
    Else
      lblResults.Text = "Nie znaleziono wpisw dla danej daty lub kategorii."
    End If
  End Sub

  Protected Sub btnCreateNewBlogEntry_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCreateNewBlogEntry.Click
    pnlAddEditBlogEntry.Visible = True
    pnlBlogEntries.Visible = False
    txtTitle.Text = ""
    txtBody.Value = ""
    lstCategory.SelectedIndex = -1
    calDatePublished.SelectedDate = DateTime.Now.Date
    ViewState("EditingId") = Nothing
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    If calDatePublished.SelectedDate <> DateTime.MinValue Then
      If Page.IsValid Then
        Dim myBlogEntry As BlogEntry
        If ViewState("EditingId") IsNot Nothing Then
          myBlogEntry = New BlogEntry(Convert.ToInt32(ViewState("EditingId")))
        Else
          myBlogEntry = New BlogEntry
        End If
        myBlogEntry.Title = txtTitle.Text
        myBlogEntry.Body = txtBody.Value
        myBlogEntry.CategoryId = Convert.ToInt32(lstCategory.SelectedValue)
        myBlogEntry.DatePublished = calDatePublished.SelectedDate

        BlogManager.SaveBlogEntry(myBlogEntry)
        EndEditing()

      End If
    Else
      custom1.IsValid = False
    End If
  End Sub

  Protected Sub dlBlogEntries_EditCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataListCommandEventArgs) Handles dlBlogEntries.EditCommand
    Dim id As Integer = Convert.ToInt32(e.CommandArgument)
    Dim myBlogEntry As BlogEntry = BlogManager.GetBlogEntry(id)
    If myBlogEntry IsNot Nothing Then
      ViewState("EditingId") = id
      pnlAddEditBlogEntry.Visible = True
      pnlBlogEntries.Visible = False
      txtTitle.Text = myBlogEntry.Title
      txtBody.Value = myBlogEntry.Body
      lstCategory.DataBind()
      If lstCategory.Items.FindByValue(myBlogEntry.CategoryId.ToString()) IsNot Nothing Then
        lstCategory.Items.FindByValue(myBlogEntry.CategoryId.ToString()).Selected = True
      End If
      calDatePublished.SelectedDate = myBlogEntry.DatePublished.Date
    End If
  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    EndEditing()
  End Sub

  Private Sub EndEditing()
    pnlAddEditBlogEntry.Visible = False
    pnlBlogEntries.Visible = True
    ViewState("EditingId") = Nothing
    LoadData()
  End Sub

  Protected ReadOnly Property CanEdit() As Boolean
    Get
      Return Context.User.IsInRole("Administrator")
    End Get
  End Property
End Class


